/**
 * Calendar Script
 * Creates a calendar widget which can be used to select the date more easily than using just a text box
 * http://www.openjs.com/scripts/ui/calendar/
 *
 * Example:
 * <input type="text" name="date" id="date" />
 * <script type="text/javascript">
 * 		calendar.set("date");
 * </script>
 */
calendar = {
	month_names: ["Januari","Pebruari","Maret","April","Mei","Juni","Juli","Agustus","September","Oktober","November","Desember"],
	weekdays: ["Ahad", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"],
	month_days: [31,28,31,30,31,30,31,31,30,31,30,31],
	//Get today's date - year, month, day and date
	today : new Date(),
	opt : {},
	data: [],

	//Functions
	/// Used to create HTML in a optimized way.
	wrt:function(txt) {
		this.data.push(txt);
	},
	
	/* Inspired by http://www.quirksmode.org/dom/getstyles.html */
	getStyle: function(ele, property){
		if (ele.currentStyle) {
			var alt_property_name = property.replace(/\-(\w)/g,function(m,c){return c.toUpperCase();});//background-color becomes backgroundColor
			var value = ele.currentStyle[property]||ele.currentStyle[alt_property_name];
		
		} else if (window.getComputedStyle) {
			property = property.replace(/([A-Z])/g,"-$1").toLowerCase();//backgroundColor becomes background-color

			var value = document.defaultView.getComputedStyle(ele,null).getPropertyValue(property);
		}
		
		//Some properties are special cases
		if(property == "opacity" && ele.filter) value = (parseFloat( ele.filter.match(/opacity\=([^)]*)/)[1] ) / 100);
		else if(property == "width" && isNaN(value)) value = ele.clientWidth || ele.offsetWidth;
		else if(property == "height" && isNaN(value)) value = ele.clientHeight || ele.offsetHeight;
		return value;
	},
	getPosition:function(ele) {
		var x = 0;
		var y = 0;
		while (ele) {
			x += ele.offsetLeft;
			y += ele.offsetTop;
			ele = ele.offsetParent;
		}
		if (navigator.userAgent.indexOf("Mac") != -1 && typeof document.body.leftMargin != "undefined") {
			x += document.body.leftMargin;
			offsetTop += document.body.topMargin;
		}
	
		var xy = new Array(x,y);
		return xy;
	},
	pilih_hari_c:function(hari){
		//$('#ok_c').removeClass("disabled");
		$("#table_c").find(".selected").removeClass("selected");
		$("#hari_"+hari).addClass("selected");
		$("#hari_c").val(hari);
	},
	/// Called when the user clicks on a date in the calendar.
	selectDate:function() {
		var ths = _calendar_active_instance;
		var year = $(".calendar-year").val();
		var month = parseInt($(".calendar-month").val())+1;
		var day = $("#hari_c").val();
		if(month < 10)	month	= "0" + month;
		var jam = $("#jam_c").val();
		var menit = $("#menit_c").val();
		document.getElementById(ths.opt["input"]).value = year + "-" + month + "-" + day; // Date format is :HARDCODE:
		ths.hideCalendar();
	},
	/// Creates a calendar with the date given in the argument as the selected date.
	makeCalendar:function(year, month, day) {
		year = parseInt(year);
		month= parseInt(month);
		day	 = parseInt(day);
		
		//Display the table
		var next_month = month+1;
		var next_month_year = year;
		if(next_month>=12) {
			next_month = 0;
			next_month_year++;
		}
		
		var previous_month = month-1;
		var previous_month_year = year;
		if(previous_month< 0) {
			previous_month = 11;
			previous_month_year--;
		}
		
		this.wrt("<table style='padding:10px;' id='table_c'>");
		this.wrt("<tr><th><a href='javascript:calendar.makeCalendar("+(previous_month_year)+","+(previous_month)+");' title='"+this.month_names[previous_month]+" "+(previous_month_year)+"'><i class='far fa-chevron-left'></i></a></th>");
		this.wrt("<th colspan='5' class='calendar-title'><select name='calendar-month' class='calendar-month br_n_margin' onChange='calendar.makeCalendar("+year+",this.value);'>");
		for(var i in this.month_names) {
			this.wrt("<option value='"+i+"'");
			if(i == month) this.wrt(" selected='selected'");
			this.wrt(">"+this.month_names[i]+"</option>");
		}
		this.wrt("</select>");
		this.wrt("<select name='calendar-year' class='calendar-year br_n_margin' onChange='calendar.makeCalendar(this.value, "+month+");'>");
		var current_year = this.today.getYear();
		if(current_year < 1900) current_year += 1900;
		
		for(var i=current_year-70; i<current_year+10; i++) {
			this.wrt("<option value='"+i+"'")
			if(i == year) this.wrt(" selected='selected'");
			this.wrt(">"+i+"</option>");
		}
		this.wrt("</select></th>");
		this.wrt("<th><a href='javascript:calendar.makeCalendar("+(next_month_year)+","+(next_month)+");' title='"+this.month_names[next_month]+" "+(next_month_year)+"'><i class='far fa-chevron-right' style='float:right'></i></a></th></tr>");
		this.wrt("<tr class='header'>");
		for(var weekday=0; weekday<7; weekday++) this.wrt("<td>"+this.weekdays[weekday]+"</td>");
		this.wrt("</tr>");
		
		//Get the first day of this month
		var first_day = new Date(year,month,1);
		var start_day = first_day.getDay();
		
		var d = 1;
		var flag = 0;
		
		//Leap year support
		if(year % 4 == 0) this.month_days[1] = 29;
		else this.month_days[1] = 28;
		
		var days_in_this_month = this.month_days[month];

		//Create the calender
		for(var i=0;i<=5;i++) {
			if(w >= days_in_this_month) break;
			this.wrt("<tr>");
			for(var j=0;j<7;j++) {
				if(d > days_in_this_month) flag=0; //If the days has overshooted the number of days in this month, stop writing
				else if(j >= start_day && !flag) flag=1;//If the first day of this month has come, start the date writing

				if(flag) {
					var w = d, mon = month+1;
					if(w < 10)	w	= "0" + w;
					if(mon < 10)mon = "0" + mon;

					//Is it today?
					var class_name = '';
					var yea = this.today.getYear();
					if(yea < 1900) yea += 1900;

					if(yea == year && this.today.getMonth() == month && this.today.getDate() == d) class_name = " today";
					if(day == d) class_name += " selected";
					class_name += " " + this.weekdays[j].toLowerCase();

					//this.wrt("<td class='days"+class_name+"'><a href='javascript:calendar.selectDate(\""+year+"\",\""+mon+"\",\""+w+"\")'>"+w+"</a></td>");
					this.wrt("<td class='days"+class_name+"' id='hari_"+w+"'><a href='javascript:calendar.pilih_hari_c(\""+w+"\")' >"+w+"</a></td>");
					d++;
				} else {
					this.wrt("<td class='days'>&nbsp;</td>");
				}
			}
			this.wrt("</tr>");
		}
		this.wrt("</table>");

		//buat jam by shan
		//tambahan untuk jam menit dan detik by Shan
		var tanggal_c= $("#"+this.opt['input']).val();
		var  t_ = tanggal_c.split(" ");
		if(tanggal_c != "" && t_.length == 2){
			var  t_0 = tanggal_c.split(" ");
			var t_1 = t_0[1];
			var t_2 = t_1.split(":");
			var jam_nya = t_2[0];
			var menit_nya = t_2[1];
		}else{
			var jam_nya = "-1";
			var menit_nya = "-1";
		}
		
		this.wrt("<hr style='margin-top:5px;margin-bottom:2px'>");
		this.wrt("<tr><th colspan='3'><span style='margin-right:15px;'><i class='far fa-stopwatch'></i> jam : </span></th>");
		this.wrt("<th colspan='4' ><select title='Jam' style='width:30%' id='jam_c' name='calendar-jam' class=' br_n_margin'>");
			this.wrt("<option value='00' selected>jam</option>");
		for(var i=0; i<=24; i++) {
			if(i == parseInt(jam_nya)){
				var pilihj_c = "selected";
			}else{
				var pilihj_c = "";
			}
			if(i < 10)	i	= "0" + i;
			this.wrt("<option value='"+i+"' "+pilihj_c+"");
			this.wrt(">"+i+"</option>");
		}
		this.wrt("</select>");
		this.wrt("<select style='width:30%' title='menit' id='menit_c' name='calendar-menit' class='br_n_margin' >");
			this.wrt("<option value='00' selected>menit</option>");
		for(var i=0; i<=60; i++) {
			if(i == parseInt(menit_nya)){
				var pilihm_c = "selected";
			}else{
				var pilihm_c = "";
			}
			if(i < 10)	i	= "0" + i;
			this.wrt("<option value='"+i+"' "+pilihm_c+"")
			this.wrt(">"+i+"</option>");
		}
		this.wrt("</select></th>");
		this.wrt("</tr>");
		if(day < 10)	day	= "0" + day;
		this.wrt("<input type='hidden' id='hari_c' value='"+day+"'/>");
		this.wrt("<hr style='margin-bottom:0px;margin-top:2px'>");
		//akhir tambahan jam menit dan detik by Shan

		this.wrt("<center><button id='ok_c' class='btn btn-flat btn-sm btn-info m-3' onclick='calendar.selectDate();' ><i class='far fa-check-circle'></i> Ok</button><button class='btn btn-flat btn-sm btn-default m-3' onclick='calendar.hideCalendar();' ><i class='far fa-times-circle'></i> Batal</button></center>");

		document.getElementById(this.opt['calendar']).innerHTML = this.data.join("");
		this.data = [];
	},
	
	/// Display the calendar - if a date exists in the input box, that will be selected in the calendar.
	showCalendar: function() {
		var input = document.getElementById(this.opt['input']);
		
		//Position the div in the correct location...
		var div = document.getElementById(this.opt['calendar']);
		var xy = this.getPosition(input);
		var width = parseInt(this.getStyle(input,'width'));
		div.style.left=(xy[0]+width+10)+"px";
		div.style.top=xy[1]+"px";

		// Show the calendar with the date in the input as the selected date
		var existing_date = new Date();
		var date_in_input = input.value;
		if(date_in_input) {
			var selected_date = false;
			var date_parts = date_in_input.split("-");
			var tgl_hari = date_parts[2].split(" ");
			if(date_parts.length == 3) {
				date_parts[1]--; //Month starts with 0
				selected_date = new Date(date_parts[0], date_parts[1], tgl_hari[0]);
			}
			if(selected_date && !isNaN(selected_date.getYear())) { //Valid date.
				existing_date = selected_date;
			}
		}
		
		var the_year = existing_date.getYear();
		if(the_year < 1900) the_year += 1900;
		this.makeCalendar(the_year, existing_date.getMonth(), existing_date.getDate());
		document.getElementById(this.opt['calendar']).style.display = "block";
		_calendar_active_instance = this;
	},
	
	/// Hides the currently show calendar.
	hideCalendar: function(instance) {
		var active_calendar_id = "";
		if(instance) active_calendar_id = instance.opt['calendar'];
		else active_calendar_id = _calendar_active_instance.opt['calendar'];
		
		if(active_calendar_id) document.getElementById(active_calendar_id).style.display = "none";
		_calendar_active_instance = {};
	},
	
	/// Setup a text input box to be a calendar box.
	set: function(input_id) {
		var input = document.getElementById(input_id);
		if(!input) return; //If the input field is not there, exit.
		
		if(!this.opt['calendar']) this.init();
		
		var ths = this;
		// saya edit sendiri, sehingga tidak harus klik cukup focus aja
		//input.onclick=function(){
		  input.onfocus=function(){	
			ths.opt['input'] = this.id;
			ths.showCalendar();
		};
	},
	
	/// Will be called once when the first input is set.
	init: function() {
		if(!this.opt['calendar'] || !document.getElementById(this.opt['calendar'])) {
			var div = document.createElement('div');
			if(!this.opt['calendar']) this.opt['calendar'] = 'calender_div_'+ Math.round(Math.random() * 100);

			div.setAttribute('id',this.opt['calendar']);
			div.className="calendar-box";

			document.getElementsByTagName("body")[0].insertBefore(div,document.getElementsByTagName("body")[0].firstChild);
		}
	}
}
