/*
 * CBTN SPAN PTKIN 2017
 * Modified by  2017 by affandeZone
 * e: affandes[at]gmail[dot]com
 * app.js update: 5/14/17 9:44 AM
 */

/*
 * CBTL SPAN PTKIN
 * Copyright (c) 2017 by affandeZone
 * e: affandes[at]gmail[dot]com
 * app.js update: 3/12/17 11:57 AM
 */

/**
 * Created by IBN on 02/04/2017.
 */

const _TIME_INTERVAL        = 15;
const _DIV_NOTIF            = '.notifications-menu';
const _BTN_NOTIF            = '#btn-notif-header';

const _TYP_AKTIFASI = 0;
const _TYP_MODERASI = 1;

var ModelNotifikasi = {
    response: {
        'ID': '',
        'PAR': '',
        'TYP': 0,
        'MSG': '',
        'DT': '',
        'PGN': '',
        'TG': '',
        'LV': '',
    },

    aktifasi: {
        id: 0,
        ptkin: '-',
        ujian: '-',
        status: '-',
    },

    moderasi: {
        id: 0,
        idUj : '',
        idRgn : '',
        ujian : '',
        ruangan : '',
        ptkin : '',
        alasan : ''
    },

    aktifasiTimeline: {
        id: 0,
        type: '',
        jam: '',
        ptkin: '',
        ujian: '',
        status: '-',
        icon: '-',
        label: '-',
        lv: '-',
    },

    moderasiTimeline: {
        id: 0,
        type: '',
        jam: '',
        ptkin: '',
        alasan: ''
    },
};

var TemplateNotifikasi = {
    loadingInfo: function() {
        var html = '<i class="fa fa-spinner fa-spin fa-fw"></i>';
        return html;
    },
    loadingContent: function() {
        var html = '<div class="loading"><i class="fa fa-spinner fa-spin fa-2x fa-fw"></i> <br>Loading...</div>';
        return html;
    },

    listMsgDefault: function(d){
        var data = d || ModelNotifikasi.response;

        var html = '<li><a href="'+$('#g-url-api').data('ni')+'">';
        html += '<i class="fa fa-info-circle text-info"></i> <span><%= MSG %></span>';
        html += '</a></li>';

        return _.template(html)(data);
    },

    listAktifasi: function(d)
    {
        var o = '';
        try {
            o = JSON.parse(d.DT);
        } catch (e) {
            return this.listMsgDefault(d);
        }

        ModelNotifikasi.aktifasi.id     = d.ID;
        ModelNotifikasi.aktifasi.ptkin  = o.ptkin;
        ModelNotifikasi.aktifasi.ujian  = o.ujian;
        ModelNotifikasi.aktifasi.status = o.status.toLowerCase();

        var html = '<li><a href="'+$('#g-url-api').data('ni')+'">';
        html += '<i class="fa fa-star text-success"></i> <span>PTKIN <b><%= ptkin %></b> telah meng<%= status %>kan ujian <%= ujian %>.</span>';
        html += '</a></li>';

        return _.template(html)(ModelNotifikasi.aktifasi);
    },

    listModerasi: function(d)
    {
        var o = '';
        try {
            o = JSON.parse(d.DT);
        } catch (e) {
            return this.listMsgDefault(d);
        }

        ModelNotifikasi.moderasi.id     = d.ID;
        ModelNotifikasi.moderasi.idUj   = o.idUj;
        ModelNotifikasi.moderasi.idRgn  = o.idRgn;
        ModelNotifikasi.moderasi.ujian  = o.ujian;
        ModelNotifikasi.moderasi.ptkin  = o.ptkin;
        ModelNotifikasi.moderasi.ruangan= o.ruangan;
        ModelNotifikasi.moderasi.alasan = o.alasan;

        var html = '<li><a '+(d.LV != 'mdr' ? 'href="'+$('#g-url-api').data('ni')+'"' : '')+'>';
        html += '<i class="fa fa-clock-o text-warning"></i> <span>'+d.MSG+'</span> ';

        if(d.LV == 'mdr'){
            html += '<button onclick="window.location = $(\'#g-url-api\').data(\'mi\');" class="btn btn-primary btn-xs" style="cursor:pointer; margin-left: 23px; margin-top: 6px;">Lihat Detail Moderasi</button>';
        } else {
            $('#read-notif').hide();
        }

        html += '</a></li>';

        return _.template(html)(ModelNotifikasi.moderasi);
    }
}

var Sound = {
    soundObj : document.getElementById('beep'),
    html : '<embed src="/web/sound/fuzzybeep.wav" type="audio/x-wav" autostart="true" id="beep" enablejavascript="true">',
    generateHtml : function(){
        if(this.soundObj == null){
            // $('body').append(this.html);
        }
    },
    play : function () {
        if(this.soundObj != null){
            // TODO :: Issue, tidak bisa play beep music play()
            // this.soundObj.play();
        }
    }
};

var Notifikasi = {

    btnNotif : $(_BTN_NOTIF),
    btnReadAllNotif : $(_DIV_NOTIF + ' #read-notif'),
    divNotif : $(_DIV_NOTIF),
    data: [],
    count: 0,

    setInfo: function(msg){
        // Notifikasi.divNotif.find('.header .info').html(msg);
    },

    setContent: function(msg){
        Notifikasi.divNotif.find('.content').html(msg);
    },

    setLoadingInfo : function(){
        this.setInfo(TemplateNotifikasi.loadingInfo());
    },

    setLoadingContent : function(){
        this.setContent(TemplateNotifikasi.loadingContent());
    },

    setCountNotification: function(count){
        if(count > 0){
            this.btnNotif.find('.label').html(count);
            this.setInfo('Anda memiliki ' + count + ' notifikasi.');
        }
    },

    resetCountNotification: function(){
        this.btnNotif.find('.label').html('');
        this.setInfo('');
    },

    setStatus: function(type, msg){
        msg = msg || 'Maaf, Anda tidak bisa melakukan kegiatan karena server bermasalah.';
        var icon;
        switch (type){
            case 'success': icon = '<i class="fa fa-check-circle fa-2x text-success" style="margin-right: 5px;"></i>';     break;
            case 'warning': icon = '<i class="fa fa-warning fa-2x text-warning" style="margin-right: 5px;"></i>';          break;
            case 'error':   icon = '<i class="fa fa-times-circle fa-2x text-danger" style="margin-right: 5px;"></i>';      break;
            case 'empty':   icon = '<i class="fa fa-flag-o fa-2x text-gray" style="margin-right: 5px;"></i>';      break;
        }
        this.setInfo('');
        this.setContent('<div class="msg ' + (type == 'empty' ? 'text-gray' : '' ) + '">' + icon + ' <br> ' + msg + '</div>');
    },

    filterTemplate: function(obj){
        switch (obj.TYP){
            case _TYP_AKTIFASI : return TemplateNotifikasi.listAktifasi(obj);
            case _TYP_MODERASI : return TemplateNotifikasi.listModerasi(obj);
        }
    },

    prepandListOnContent : function (data) {
        var menu = this.divNotif.find('.menu');
        $.each(data, function(i){
            menu.prepend(Notifikasi.filterTemplate(data[i]));
        });
    },

    setListOnContent : function (data) {
        var html = '<ul class="menu">';
        $.each(data, function(i){
            html += Notifikasi.filterTemplate(data[i]);
        });
        html += '</ul>';

        this.setContent(html);
    },

    loadListNotifikasi : function(loading){
        if(loading){
            Notifikasi.setLoadingInfo();
            Notifikasi.setLoadingContent();
        }

        $.ajax({
            //url: '/notifikasi/lihat',
            url: $('#g-url-api').data('nl'),
            data: {},
            method: 'get',
            dataType: 'json',
            success: function(r){
                if(!r.s){
                    Notifikasi.setStatus('warning', r.m);
                } else {
                    Notifikasi.count = 0;
                    Notifikasi.setCountNotification(Notifikasi.count);
                    Notifikasi.data = r.d;

                    if(Notifikasi.data.length > 0){
                        if(Notifikasi.divNotif.find('.content .msg .menu').length > 0){
                            Notifikasi.prepandListOnContent(r.d);
                        } else {
                            Notifikasi.setListOnContent(r.d);
                        }

                        Notifikasi.setInfo('Anda memiliki ' + Notifikasi.data.length + ' notfikasi');
                    } else {
                        Notifikasi.setStatus('empty', r.m);
                    }
                }
            },
            error: function(xhr, status, error) {
                if(xhr.responseJSON != undefined && xhr.responseJSON.m != undefined){
                    Notifikasi.setStatus('warning', xhr.responseJSON.m);
                } else {
                    if(error == 'Found') {
                        window.location = $('#g-url-api').data('hm')
                    } else {
                        error = error || 'Maaf, Tidak bisa koneksi ke server PTKIN.';
                        obj.setStatusServer('error', error);
                    }
                }
            },
            complete: function(){
                // Triger Finish
            }
        });
    },

    loadCekNotifikasi : function(loading){
        if(loading === true){
            Notifikasi.setLoadingContent();
        }

        $.ajax({
            //url: '/notifikasi/cek',
            url: $('#g-url-api').data('nc'),
            data: {},
            method: 'get',
            dataType: 'json',
            success: function(r){
                if(!r.s){
                    Notifikasi.setStatus('warning', r.m);
                } else {
                    Notifikasi.count = r.d;
                    if(Notifikasi.data.length == 0){
                        Notifikasi.setStatus('empty', r.m);
                    }
                    if(Notifikasi.count > 0){
                        Sound.play();
                        Notifikasi.setCountNotification(Notifikasi.count);
                    }
                }
            },
            error: function(xhr, status, error) {
                if(xhr.responseJSON != undefined && xhr.responseJSON.m != undefined){
                    Notifikasi.setStatus('warning', xhr.responseJSON.m);
                } else {
                    if(error == 'Found') {
                        window.location = $('#g-url-api').data('hm')
                    } else {
                        error = error || 'Maaf, Tidak bisa koneksi ke server PTKIN.';
                        obj.setStatusServer('error', error);
                    }
                }
            },
            complete: function(){
                // Triger Finish
            }
        });
    },


    loadBacaNotif : function(loading){
        if(loading === true){
            Notifikasi.setLoadingContent();
        }

        $.ajax({
            //url: '/notifikasi/baca-notif',
            url: $('#g-url-api').data('bn'),
            data: {},
            method: 'get',
            dataType: 'json',
            success: function(r){
                if(!r.s){
                    Notifikasi.setStatus('warning', r.m);
                } else {
                    Notifikasi.count = r.d;
                    if(Notifikasi.data.length == 0){
                        Notifikasi.setStatus('empty', r.m);
                    }
                    if(Notifikasi.count > 0){
                        Notifikasi.setCountNotification(Notifikasi.count);
                    }
                }
            },
            error: function(xhr, status, error) {
                if(xhr.responseJSON != undefined && xhr.responseJSON.m != undefined){
                    Notifikasi.setStatus('warning', xhr.responseJSON.m);
                } else {
                    if(error == 'Found') {
                        window.location = $('#g-url-api').data('hm')
                    } else {
                        error = error || 'Maaf, Tidak bisa koneksi ke server PTKIN.';
                        obj.setStatusServer('error', error);
                    }
                }
            },
            complete: function(){
                // Triger Finish
            }
        });
    },

    eventReadAllNotif : function(){
        this.btnReadAllNotif.click(function () {
            $.ajax({
                //url: '/notifikasi/read-all',
                url: $('#g-url-api').data('ra'),
                data: {},
                method: 'get',
                dataType: 'json',
                success: function(r){
                    if(!r.s){
                        Notifikasi.setStatus('warning', r.m);
                    } else {
                        Notifikasi.setStatus('empty', r.m);
                    }
                },
                error: function(xhr, status, error) {
                    if(xhr.responseJSON != undefined && xhr.responseJSON.m != undefined){
                        Notifikasi.setStatus('warning', xhr.responseJSON.m);
                    } else {
                        if(error == 'Found') {
                            window.location = $('#g-url-api').data('hm')
                        } else {
                            error = error || 'Maaf, Tidak bisa koneksi ke server PTKIN.';
                            obj.setStatusServer('error', error);
                        }
                    }
                },
                complete: function(){
                    // Triger Finish
                }
            });
        });
    },

    eventToogleNotif: function(){
        this.btnNotif.click(function(){
            if(Notifikasi.divNotif.hasClass('open')){
                Notifikasi.divNotif.removeClass('open');
            } else {
                Notifikasi.divNotif.addClass('open');
                Notifikasi.loadBacaNotif(true);
                Notifikasi.loadListNotifikasi(true);
                Notifikasi.resetCountNotification();
                Moderasi.setMsgModal(undefined);
            }
        });
    },

    run: function(){
        this.loadCekNotifikasi(false);
    },

    init: function(){
        this.eventToogleNotif();
        this.eventReadAllNotif();
        this.loadCekNotifikasi();

        Sound.generateHtml();

        setInterval(function () {
            Notifikasi.run();
        }, _TIME_INTERVAL * 1000);
    }
}


Notifikasi.init();