<?php
function distance($lat1, $lon1, $lat2, $lon2, $unit) {
 
  $theta = $lon1 - $lon2;
  $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
  $dist = acos($dist);
  $dist = rad2deg($dist);
  $miles = $dist * 60 * 1.1515;
  $unit = strtoupper($unit);
 
  if ($unit == "K") { //kilometer
        return ($miles * 1.609344);
    } else if ($unit == "METER") { //meter
        return ($miles * 1.609344 * 1000);
    }  else if ($unit == "N") {
        return ($miles * 0.8684);
    } else {
        return $miles; //miles
    }
}
 
echo distance(-0.326636, 103.154260, 0, 0, "M") . " Miles<br>";
echo distance(-0.326636, 103.154260, -2.608350, 140.675299, "K") . " Kilo Meter<br>";
echo distance(-0.326636, 103.154260, -2.608350, 140.675299, "METER") . " Meter<br>";
?>